
'MODUL        Teilnehmer aus Spreadsheet importieren
'EINGABEDATEN siehe Eigenschaft "Datenherkunft" des Formulars und ev. seiner Unterformulare
'             pub_PfadHilfedatei
'AUSGABEDATEN genderte Formularwerte
'AUTOR        mlu
'GENDERT     30.11.01
'NOTATION     siehe ? rechts oben in Tests.chm

Option Compare Database
Option Explicit

'Formularereignis
'----------------
'--- 2. Schritt des Teilnehmerimports (1. Schritt BtnTeilnehmerImportieren_Click von FrmTestauswahl)
Private Sub Form_Open(Cancel As Integer)
  '-- OpenArgs ist die aus FrmNachschlagetabellen beim ffnen von FrmTeilnehmerImportieren bergebene Wertliste
  Me![LstTeilnehmerSpreadsheets].RowSource = Me.OpenArgs
End Sub

'Schaltflchen
'-------------
'~~~ Ruft HTML Help Workshop als externe DLL HHCtrl.ocx
Private Sub BtnHilfe_Click()
  Call HtmlHelp(0, pub_PfadHilfedatei, HH_DISPLAY_TOPIC, ByVal "TeilnehmerImportieren.htm")
End Sub

'--- 3a. Bricht Teilnehmerimport ab
Private Sub BtnLstTeilnehmerSpreadsheetsAbbrechen_Click()
  DoCmd.Close acForm, "FrmTeilnehmerImportieren"
End Sub

'--- 3b. Startet Teilnehmerimport
Private Sub BtnOkLstTeilnehmerSpreadsheets_Click()
  Dim dbs As Database
  Dim rstTmpNeueTEILNEHMER As Recordset
  Dim rstTEILNEHMER As Recordset
  Dim lfTestschlssel As Long
  Dim neueMatrikel As String
  Dim MatrikelnummerUngltig As Boolean
  Dim PrimrschlsselDoppelt As Boolean
  Dim gewarnt As Boolean
  Dim Fehlermeldung As String
  On Error GoTo Fehlerbehandlung

  If IsNull(Me![LstTeilnehmerSpreadsheets]) Then
    MsgBox "Whlen Sie ein Tabellenblatt oder 'Abbrechen'.", vbOKOnly + vbExclamation, "Kein Tabellenblatt gewhlt"
    Exit Sub  '------------------------------------->>>
  End If
  Set dbs = CurrentDb
  With dbs
    .Execute "DELETE * FROM TmpNeueTEILNEHMER;"
    .Execute "DELETE * FROM TmpImportfehler;"
    '-- Das gewhlte Tabellenblatt aus Wertliste (s. Form_Open) whlen und in TmpNeueTEILNEHMER importieren
    '?? Access 2000-Bugs bzw. fehlende Information (s. Hilfetext und MS Knowledge Base)
    '   ------------------------------
    '   1) Spalte Matrikelnummer innerhalb von MS  E x c e l  als Text formatieren
    '   2) Felder von TmpNeueTEILNEHMER als F1, F2, F3 bezeichnen
    DoCmd.TransferSpreadsheet acImport, , "TmpNeueTEILNEHMER", Me![LstTeilnehmerSpreadsheets], False

    '-- Fr alle Zeilen von TmpNeueTEILNEHMER: Laufenden Testschlssel einfgen und an TEILNEHMER anfgen
    Set rstTmpNeueTEILNEHMER = .OpenRecordset("TmpNeueTEILNEHMER")
    Set rstTEILNEHMER = .OpenRecordset("TEILNEHMER")
    lfTestschlssel = [Forms]![FrmTestauswahl]![Subfrm Testtermine]![Testschlssel]
    With rstTEILNEHMER
      gewarnt = False
      Do While Not rstTmpNeueTEILNEHMER.EOF
        neueMatrikel = rstTmpNeueTEILNEHMER!F1
        flleLinksMitNullen neueMatrikel
        If pub_MatrikelGltig(neueMatrikel) <> True Then
          '-- falls noch keine Meldung zu MatrikelnummerUngltig
          If MatrikelnummerUngltig = False And gewarnt = False Then
            MatrikelnummerUngltig = True
            MsgBox "Jeden Satz mit fehlerhafter Matrikelnummer finden Sie im " & Chr(13) & _
                   "Register Importfehler des Formulars 'Nachschlagetabellen ndern'.", vbOKOnly + vbExclamation, "Mindestens eine der Matrikelnummern ist ungltig"
            gewarnt = True
          End If
          '-- Anfgen, falls Matrikelnummer ungltig
          dbs.Execute "INSERT INTO TmpImportfehler (Testschlssel, F1,F2,F3,Fehlerklasse) VALUES ('" & lfTestschlssel & "', '" & neueMatrikel & "', '" & rstTmpNeueTEILNEHMER!F2 & "', '" & rstTmpNeueTEILNEHMER!F3 & "', 'Matrikelnummer ungltig');", dbFailOnError
        Else
          '-- Nur anfgen, falls Matrikelnummer gltig
          .AddNew
            !Testschlssel = lfTestschlssel
            !Matrikelnummer = neueMatrikel
            !Geschlechtsname = rstTmpNeueTEILNEHMER!F2
            !Vorname = rstTmpNeueTEILNEHMER!F3
          .Update
        End If
        rstTmpNeueTEILNEHMER.MoveNext
      Loop
      rstTmpNeueTEILNEHMER.Close
      Set rstTmpNeueTEILNEHMER = Nothing
      .Close
    End With 'rstTEILNEHMER
    Set rstTEILNEHMER = Nothing
  End With 'dbs
  DoCmd.Close acForm, "FrmTeilnehmerImportieren"
  '-- Zwei Unterformulare aktualisieren
  DoCmd.OpenForm "FrmNachschlagetabellen"                             '+++++>
  Forms!FrmNachschlagetabellen![Unterfrm Teilnehmer].Requery
  If MatrikelnummerUngltig = True Or PrimrschlsselDoppelt Then
    DoCmd.GoToControl "Unterfrm TmpImportfehler"
    Forms!FrmNachschlagetabellen![Unterfrm TmpImportfehler].Requery
  End If
  DoCmd.Close acForm, "FrmTeilnehmerImportieren"
  Exit Sub

Fehlerbehandlung:
  If Err.Number = cPrimrschlsselDoppelt Then
    '-- falls noch keine Meldung zu PrimrschlsselDoppelt
    If PrimrschlsselDoppelt = False And gewarnt = False Then
      PrimrschlsselDoppelt = True
      MsgBox "Jeden Satz mit fehlerhafter Matrikelnummer finden Sie im " & Chr(13) & _
             "Register Importfehler des Formulars 'Nachschlagetabellen ndern'.", vbOKOnly + vbExclamation, cHdPrimrschlsselDoppelt
    End If
    dbs.Execute "INSERT INTO TmpImportfehler (Testschlssel, F1,F2,F3,Fehlerklasse) VALUES ('" & lfTestschlssel & "', '" & neueMatrikel & "', '" & rstTmpNeueTEILNEHMER!F2 & "', '" & rstTmpNeueTEILNEHMER!F3 & "', 'Primrschlssel doppelt vorhanden');", dbFailOnError
    Resume Next
'  ElseIf Err.Number = cNrTypenUnvertrglich Then
'    Resume Next
  ElseIf Err.Number = cNrTransferSpreadsheetAbgebrochen Then
    Exit Sub  '------------------------------------->>>
  ElseIf Err.Number <> 0 Then
    Fehlermeldung = Err.Number & " " & Err.Description & " (BtnOkLstTeilnehmerSpreadsheets_Click)"
    MsgBox Fehlermeldung, vbOKOnly + vbExclamation, cHdDefault
  End If
End Sub

Private Sub flleLinksMitNullen(ByRef Str As String)
  Dim ZahlZch As Integer

  ZahlZch = Len(Str)
  If ZahlZch < 8 Then
    ZahlZch = 8 - ZahlZch
    Str = String(ZahlZch, "0") & Str
  End If
End Sub

'~~~ Access-Fehlerbehandlung
Private Sub Form_Error(DataErr As Integer, Response As Integer)
  MsgBox "'" & DataErr & "  " & Error(DataErr) & "' im Formular " & "TEILNEHMER IMPORTIEREN", vbOKOnly + vbExclamation, cHdDefault
  Response = acDataErrContinue
End Sub

